
/*
* Copyright (C) 2016 Texas Instruments Incorporated - www.ti.com
*
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

/* HALCoGen Register Definition Includes Files */
#include "sys_common.h"
#include "sys_dma.h"

/* HALCoGen Drivers Include Files */
#include "crc.h"
#include "rti.h"

/* CG Tools Include Files */
#include <stdio.h>

/* Application Include Files */
#include "crcSemiCPU.h"

/* Global and Extern Variables */
extern const CRC_TABLE _my_crc_table;
g_crcSemiCpuCtrl gMyCrcCtrl = {
		.bInitialized = false,
		.g_crcTable = &_my_crc_table,
		.i32LastEntry = 0l,
		.u32DmaRequLine = 19ul,
		.eDmaChannel = DMA_CH0};

int main(void)
{
	/* Initialize RTI Module */
	rtiInit();


#ifdef RM57_OR_LC43
	/* Setting RTI compare 3 period to 13 will provoke timeout errors in the CRC module (Default: 9) */
	// rtiSetPeriod(rtiREG1, rtiCOMPARE3, 13); /* This can be used to change the RTI compare 3 period */

	rtiStartCounter(rtiREG1, rtiCOUNTER_BLOCK1);
	rtiEnableNotification(rtiREG1, 1ul << 11); /* Enable DMA request 3 (bit 11) */
#else
	/* Setting RTI compare 3 period to 12 will provoke timeout errors in the CRC module (Default: 10) */
	// rtiSetPeriod(rtiREG1, rtiCOMPARE3, 12); /* This can be used to change the RTI compare 3 period */

	rtiStartCounter(rtiCOUNTER_BLOCK1);
	rtiEnableNotification(1ul << 11); /* Enable DMA request 3 (bit 11) */
#endif

	/* Initialize CRC Module */
	crcInit();

	/* Enable CPU IRQ line */
	_enable_IRQ();

	printf("Start CRC Calculation in Semi CPU Mode (IRQ based)\n");

	/* Enable DMA module : this brings DMA out of reset */
	dmaEnable();

	/* Enable all interrupts for Channel 0 */
	crcEnableNotification(crcREG,
			CRC_CH1_CC |
			CRC_CH1_FAIL |
			CRC_CH1_OR |
			CRC_CH1_UR |
			CRC_CH1_TO);

	/* Issue first CRC calculation */
	crcSemiCpuMode(crcREG, &gMyCrcCtrl);

	while(1); /* Loop for ever. */
}
